	page    132,60
;****************************************************************************
;	INOUT.ASM
;	Example program to evaluate CODEC I/O
; 
;******************************************************************************

	nolist
	include 'ioequlc.asm'
	include 'leonid.asm'
	list

RedLED  macro mode      ; RedLED clr/set/chg
	b\mode #13,X:$FFE4
	endm

buflen  equ     64
batch equ    16

	org     p:user_code

	move                #buffer+2,r7  ;for the CODEC's interrupt routine
	move                #<buflen*4-1,m7

	move                #buffer,r2 ;for us to address the input and output samples
	move                #<4-1,n2
	move                #<buflen*4-1,m2

; initialize codec
; fs = 16 kHz, mic input, headphones and line output, no gain/attenuation
;;	ctrlcd	1,r2,buflen,LINEI,0.0,0.0,LINEO|HEADP,0.0,0.0
	ctrlcd	1,r2,buflen,MIC,0.0,0.0,LINEO|HEADP,0.0,0.0
	opencd	16,NOHPF

; Main Loop

; wait for one sample
loop	waitblk r2,buflen,batch

        .loop #batch        ;straight input->output copy for "trivial" debugging
          move X:(r2)+,a
          move a,Y:(r2)
	  move X:(r2)+,b
          move b,Y:(r2)+
          move (r2)+
        .endl

	RedLED	chg		; toggle Red Led for testing
	jcs	<set
	bset	#3,x:m_pcd
	jmp	loop
set
	bclr	#3,x:m_pcd
	jmp	loop

	org X:$0100
dat	ds 1
buffer   dsm buflen*4   ;CODEC's input buffer
	org Y:$0100
	 dsm buflen*4   ;CODEC's output buffer

	end



